import React from 'react';
import { Percent, Menu } from 'lucide-react';

export function Navbar() {
  return (
    <nav className="bg-white shadow-md">
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div className="flex justify-between h-16">
          <div className="flex items-center">
            <Percent className="w-8 h-8 text-blue-600" />
            <span className="ml-2 text-xl font-bold text-gray-800">Intentional Saver</span>
          </div>
          
          <div className="hidden sm:flex items-center space-x-8">
            <a href="#calculator" className="text-gray-600 hover:text-blue-600">Calculator</a>
            <a href="#categories" className="text-gray-600 hover:text-blue-600">Categories</a>
            <a href="#coupons" className="text-gray-600 hover:text-blue-600">Coupon Sites</a>
            <a href="#cards" className="text-gray-600 hover:text-blue-600">Credit Cards</a>
          </div>
          
          <div className="sm:hidden flex items-center">
            <button className="text-gray-600">
              <Menu className="w-6 h-6" />
            </button>
          </div>
        </div>
      </div>
    </nav>
  );
}