<?php
// Include configuration and helper files
require_once 'config/database.php';
require_once 'includes/categories.php';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Intentional Saver - Smart Money Saving Tools</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://unpkg.com/lucide-icons/dist/umd/lucide-icons.js" rel="stylesheet">
    <script src="https://unpkg.com/lucide-icons"></script>
</head>
<body class="min-h-screen bg-gray-50">
    <!-- Navigation -->
    <?php include 'includes/navbar.php'; ?>
    
    <!-- Hero Section -->
    <div class="bg-blue-600 text-white py-16">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
            <h1 class="text-4xl font-bold mb-4">Smart Savings Start Here</h1>
            <p class="text-xl text-blue-100">Discover the best tools and resources to maximize your savings</p>
        </div>
    </div>

    <!-- Calculator Section -->
    <section id="calculator" class="py-16">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <h2 class="text-3xl font-bold text-center mb-12">Savings Calculator</h2>
            <?php include 'includes/calculator.php'; ?>
        </div>
    </section>

    <!-- Categories Section -->
    <section id="categories" class="py-16 bg-gray-100">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <h2 class="text-3xl font-bold text-center mb-12">Savings Categories</h2>
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
                <?php foreach ($categories as $category): ?>
                    <?php include 'includes/category-card.php'; ?>
                <?php endforeach; ?>
            </div>
        </div>
    </section>

    <!-- Coupon Sites Section -->
    <section id="coupons" class="py-16">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <h2 class="text-3xl font-bold text-center mb-12">Top Coupon Sites</h2>
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
                <?php include 'includes/coupon-sites.php'; ?>
            </div>
        </div>
    </section>

    <!-- Credit Card Perks Section -->
    <section id="cards" class="py-16 bg-gray-100">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <h2 class="text-3xl font-bold text-center mb-12">Credit Card Rewards</h2>
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
                <?php include 'includes/credit-cards.php'; ?>
            </div>
        </div>
    </section>

    <!-- Footer -->
    <footer class="bg-gray-800 text-white py-8">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center">
                <p class="text-gray-400">© <?php echo date('Y'); ?> intentionalsaver.com. All rights reserved.</p>
            </div>
        </div>
    </footer>

    <script src="js/calculator.js"></script>
</body>
</html>