<?php
$creditCards = [
    [
        'name' => 'Cash Back Rewards',
        'issuer' => 'Various Banks',
        'description' => 'Cards offering 1-5% cash back on purchases',
        'category' => 'Cash Back'
    ],
    [
        'name' => 'Travel Rewards',
        'issuer' => 'Major Airlines',
        'description' => 'Earn miles and travel perks with every purchase',
        'category' => 'Travel'
    ],
    [
        'name' => 'Store Cards',
        'issuer' => 'Retail Stores',
        'description' => 'Special discounts and rewards at your favorite stores',
        'category' => 'Retail'
    ]
];

foreach ($creditCards as $card): ?>
    <div class="bg-white rounded-lg shadow-md p-6">
        <h3 class="text-xl font-semibold mb-2"><?php echo htmlspecialchars($card['name']); ?></h3>
        <p class="text-gray-500 text-sm mb-2">Issued by: <?php echo htmlspecialchars($card['issuer']); ?></p>
        <p class="text-gray-600"><?php echo htmlspecialchars($card['description']); ?></p>
    </div>
<?php endforeach; ?>