<?php
$couponSites = [
    [
        'name' => 'RetailMeNot',
        'url' => 'https://www.retailmenot.com',
        'description' => 'One of the largest coupon sites with deals for thousands of retailers',
        'category' => 'All Categories'
    ],
    [
        'name' => 'Rakuten',
        'url' => 'https://www.rakuten.com',
        'description' => 'Earn cash back while shopping with exclusive deals and coupons',
        'category' => 'Cash Back'
    ],
    [
        'name' => 'Groupon',
        'url' => 'https://www.groupon.com',
        'description' => 'Daily deals on local activities, products, and services',
        'category' => 'Local Deals'
    ]
];

foreach ($couponSites as $site): ?>
    <div class="bg-white rounded-lg shadow-md p-6">
        <h3 class="text-xl font-semibold mb-2"><?php echo htmlspecialchars($site['name']); ?></h3>
        <p class="text-gray-600 mb-4"><?php echo htmlspecialchars($site['description']); ?></p>
        <a href="<?php echo htmlspecialchars($site['url']); ?>" 
           target="_blank" 
           rel="noopener noreferrer" 
           class="inline-flex items-center text-blue-600 hover:text-blue-800">
            Visit Site
            <i data-lucide="external-link" class="w-4 h-4 ml-1"></i>
        </a>
    </div>
<?php endforeach; ?>