document.addEventListener('DOMContentLoaded', function() {
    const form = document.getElementById('savings-calculator');
    const results = document.getElementById('results');
    const finalPriceEl = document.getElementById('final-price');
    const totalSavingsEl = document.getElementById('total-savings');
    const percentSavedEl = document.getElementById('percent-saved');

    function calculateSavings() {
        const originalPrice = parseFloat(form['original-price'].value) || 0;
        const discountPercent = parseFloat(form['discount-percent'].value) || 0;
        const additionalCoupon = parseFloat(form['additional-coupon'].value) || 0;
        
        const firstDiscount = originalPrice * (1 - discountPercent / 100);
        const finalPrice = firstDiscount * (1 - additionalCoupon / 100);
        const totalSavings = originalPrice - finalPrice;
        
        return {
            finalPrice: finalPrice.toFixed(2),
            savings: totalSavings.toFixed(2),
            percentSaved: ((totalSavings / originalPrice) * 100).toFixed(1)
        };
    }

    form.addEventListener('input', function() {
        if (form['original-price'].value) {
            const savings = calculateSavings();
            finalPriceEl.textContent = `$${savings.finalPrice}`;
            totalSavingsEl.textContent = `$${savings.savings}`;
            percentSavedEl.textContent = `${savings.percentSaved}%`;
            results.classList.remove('hidden');
        } else {
            results.classList.add('hidden');
        }
    });

    // Initialize Lucide icons
    lucide.createIcons();
});