<div class="bg-white rounded-lg shadow-lg p-6 max-w-md mx-auto">
    <div class="flex items-center gap-2 mb-6">
        <i data-lucide="calculator" class="w-6 h-6 text-blue-600"></i>
        <h2 class="text-2xl font-bold text-gray-800">Savings Calculator</h2>
    </div>
    
    <form id="savings-calculator" class="space-y-4">
        <div>
            <label class="block text-sm font-medium text-gray-700">Original Price ($)</label>
            <input
                type="number"
                name="original-price"
                class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500"
                placeholder="100.00"
                step="0.01"
            >
        </div>

        <div>
            <label class="block text-sm font-medium text-gray-700">Initial Discount (%)</label>
            <input
                type="number"
                name="discount-percent"
                class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500"
                placeholder="20"
                step="0.1"
            >
        </div>

        <div>
            <label class="block text-sm font-medium text-gray-700">Additional Coupon (%)</label>
            <input
                type="number"
                name="additional-coupon"
                class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500"
                placeholder="10"
                step="0.1"
            >
        </div>

        <div id="results" class="mt-6 p-4 bg-blue-50 rounded-lg hidden">
            <h3 class="text-lg font-semibold text-blue-900 mb-2">Your Savings</h3>
            <div class="space-y-2">
                <p class="text-blue-800">Final Price: <span id="final-price" class="font-bold"></span></p>
                <p class="text-green-600">Total Savings: <span id="total-savings" class="font-bold"></span></p>
                <p class="text-blue-800">Percent Saved: <span id="percent-saved" class="font-bold"></span></p>
            </div>
        </div>
    </form>
</div>